UPDATE itm_inventory SET iinv_document = 101 WHERE iinv_document BETWEEN 1 AND 100;
SELECT * from itm_inventory where iinv_document = 101 limit 1;




-- Step 4: Drop the temporary table
DROP TABLE IF EXISTS temp_items;

-- Step 1: Create a temporary table to store the deduplicated data
CREATE TEMPORARY TABLE temp_items
SELECT iinv_document, iinv_item, SUM(iinv_quantity) AS total_quantity, iinv_cost, iinv_cost_cur, iinv_price
FROM itm_inventory
WHERE iinv_document = 101
GROUP BY iinv_item;

-- Step 2: Clear the original table
DELETE FROM itm_inventory WHERE iinv_document = 101;

-- Step 3: Insert the deduplicated and summed data back into the original table
INSERT INTO itm_inventory (iinv_document, iinv_item, iinv_quantity, iinv_cost, iinv_cost_cur, iinv_price)
SELECT iinv_document, iinv_item, total_quantity, iinv_cost, iinv_cost_cur, iinv_price
FROM temp_items;

-- Step 4: Drop the temporary table
DROP TABLE IF EXISTS temp_items;
