/* isql -user SYSDBA -password masterkey "C:\Program Files (x86)\OOO REGOS SOFTWARE\REGOS - CASH SERVER\database\REGOS.fdb" -i aio_mandatory_card.sql
 Enforce mandatory loyalty card before inserting STOCK_OPR_OPERATIONS_TMP rows */
SET TERM ^ ;

CREATE OR ALTER EXCEPTION EX_MANDATORY_CARD 'Карта покупателя обязательна для продажи'^

CREATE OR ALTER TRIGGER BI_MANDATORY_CARD
FOR STOCK_OPR_OPERATIONS_TMP
ACTIVE BEFORE INSERT POSITION 0
AS
DECLARE VARIABLE V_DOC   TYPE OF COLUMN STOCK_OPR_OPERATIONS_TMP.OPR_DOCUMENT;
DECLARE VARIABLE V_CARD  TYPE OF COLUMN DOCS_DOC_SALES_REF.SLS_CARD;
BEGIN
    V_DOC = NEW.OPR_DOCUMENT;

    IF (V_DOC IS NULL) THEN
        EXIT;

    SELECT S.SLS_CARD
      FROM DOCS_DOC_SALES_REF S
     WHERE S.SLS_UUID = :V_DOC
    INTO :V_CARD;

    IF (V_CARD IS NULL) THEN
        EXCEPTION EX_MANDATORY_CARD;
END^

SET TERM ; ^
