/* isql -user SYSDBA -password masterkey1 "C:\Program Files (x86)\OOO REGOS SOFTWARE\REGOS - CASH SERVER\database\REGOS.fdb" -i aio_optogo.sql
 Auto-item maintenance trigger for STOCK_OPR_OPERATIONS_TMP */
SET TERM ^ ;

CREATE OR ALTER TRIGGER AIU_AUTOITEM
FOR STOCK_OPR_OPERATIONS_TMP
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 0
AS
DECLARE VARIABLE V_THRESHOLD        NUMERIC(18, 2) = 50000;
DECLARE VARIABLE V_AUTO_ITEM_CODE   VARCHAR(50)    = '14858';
DECLARE VARIABLE V_BASE_PRICE_TYPE  INTEGER        = 2;
DECLARE VARIABLE V_STOCK_ID         INTEGER        = 5;
DECLARE VARIABLE V_INS_ORDER        INTEGER        = 999;
DECLARE VARIABLE V_INS_VAT          NUMERIC(18, 4) = 12;
DECLARE VARIABLE V_PRIV_PROMO_1     INTEGER        = 12;
DECLARE VARIABLE V_PRIV_PROMO_2     INTEGER        = 12;

DECLARE VARIABLE V_DOC              TYPE OF COLUMN STOCK_OPR_OPERATIONS_TMP.OPR_DOCUMENT;
DECLARE VARIABLE V_AUTO_ITEM_ID     TYPE OF COLUMN STOCK_OPR_OPERATIONS_TMP.OPR_ITEM;
DECLARE VARIABLE V_AUTO_PRICE       TYPE OF COLUMN STOCK_OPR_OPERATIONS_TMP.OPR_PRICE;
DECLARE VARIABLE V_TOTAL            NUMERIC(18, 4);
DECLARE VARIABLE V_PROMO_ID         INTEGER;
DECLARE VARIABLE V_IS_RETURN        INTEGER;
BEGIN
    IF (RDB$GET_CONTEXT('USER_SESSION', 'AUTOITEM_GUARD') = '1') THEN
        EXIT;

    IF (INSERTING OR UPDATING) THEN
        V_DOC = NEW.OPR_DOCUMENT;
    ELSE
        V_DOC = OLD.OPR_DOCUMENT;

    IF (V_DOC IS NULL) THEN
        EXIT;

    SELECT S.SLS_ISRETURN
      FROM DOCS_DOC_SALES_REF S
     WHERE S.SLS_UUID = :V_DOC
    INTO :V_IS_RETURN;

    IF (COALESCE(V_IS_RETURN, 0) = 1) THEN
        EXIT;

    SELECT I.ITM_ID
      FROM CTLG_ITM_ITEMS_REF I
     WHERE I.ITM_CODE = :V_AUTO_ITEM_CODE
    INTO :V_AUTO_ITEM_ID;

    IF (V_AUTO_ITEM_ID IS NULL) THEN
        EXIT;

    SELECT FIRST 1 P.PRC_VALUE
      FROM CTLG_ITM_PRICES_REF P
     WHERE P.PRC_ITEM = :V_AUTO_ITEM_ID
       AND P.PRC_PRICE_TYPE = :V_BASE_PRICE_TYPE
    INTO :V_AUTO_PRICE;

    IF (V_AUTO_PRICE IS NULL) THEN
        V_AUTO_PRICE = 0;

    DELETE FROM STOCK_OPR_OPERATIONS_TMP S
     WHERE S.OPR_DOCUMENT = :V_DOC
       AND S.OPR_ITEM     = :V_AUTO_ITEM_ID
       AND COALESCE(S.OPR_STORNO_UUID, '') <> '';

    UPDATE STOCK_OPR_OPERATIONS_TMP S
       SET S.OPR_HAS_STORNO = 0
     WHERE S.OPR_DOCUMENT = :V_DOC
       AND S.OPR_ITEM     = :V_AUTO_ITEM_ID
       AND COALESCE(S.OPR_HAS_STORNO, 0) <> 0;

    SELECT C.CRD_PROMO
      FROM DOCS_DOC_SALES_REF S
      LEFT JOIN CTLG_RETAIL_CARDS_REF C ON C.CRD_ID = S.SLS_CARD
     WHERE S.SLS_UUID = :V_DOC
    INTO :V_PROMO_ID;

    SELECT COALESCE(SUM(S.OPR_QUANTITY * S.OPR_PRICE), 0)
      FROM STOCK_OPR_OPERATIONS_TMP S
     WHERE S.OPR_DOCUMENT = :V_DOC
       AND S.OPR_ITEM <> :V_AUTO_ITEM_ID
    INTO :V_TOTAL;

    RDB$SET_CONTEXT('USER_SESSION', 'AUTOITEM_GUARD', '1');

    IF (V_TOTAL >= V_THRESHOLD) THEN
    BEGIN
        IF ((V_PROMO_ID IS NOT NULL) AND
            ((V_PROMO_ID = V_PRIV_PROMO_1) OR (V_PROMO_ID = V_PRIV_PROMO_2))) THEN
        BEGIN
            DELETE FROM STOCK_OPR_OPERATIONS_TMP S
             WHERE S.OPR_DOCUMENT = :V_DOC
               AND S.OPR_ITEM     = :V_AUTO_ITEM_ID;
        END
        ELSE
        BEGIN
            UPDATE STOCK_OPR_OPERATIONS_TMP S
               SET S.OPR_QUANTITY    = 1,
                   S.OPR_PRICE       = :V_AUTO_PRICE,
                   S.OPR_PRICE2      = :V_AUTO_PRICE,
                   S.OPR_STOCK       = :V_STOCK_ID,
                   S.OPR_ORDER       = :V_INS_ORDER,
                   S.OPR_VAT_VALUE   = :V_INS_VAT,
                   S.OPR_HAS_STORNO  = 0,
                   S.OPR_STORNO_UUID = NULL
             WHERE S.OPR_DOCUMENT = :V_DOC
               AND S.OPR_ITEM     = :V_AUTO_ITEM_ID
               AND COALESCE(S.OPR_STORNO_UUID, '') = '';

            IF (ROW_COUNT = 0) THEN
            BEGIN
                INSERT INTO STOCK_OPR_OPERATIONS_TMP
                    (OPR_UUID,
                     OPR_DOCUMENT,
                     OPR_STOCK,
                     OPR_ITEM,
                     OPR_QUANTITY,
                     OPR_PRICE,
                     OPR_PRICE2,
                     OPR_ORDER,
                     OPR_VAT_VALUE,
                     OPR_HAS_STORNO,
                     OPR_STORNO_UUID)
                VALUES
                    (GEN_UUID(),
                     :V_DOC,
                     :V_STOCK_ID,
                     :V_AUTO_ITEM_ID,
                     1,
                     :V_AUTO_PRICE,
                     :V_AUTO_PRICE,
                     :V_INS_ORDER,
                     :V_INS_VAT,
                     0,
                     NULL);
            END
        END
    END
    ELSE
    BEGIN
        DELETE FROM STOCK_OPR_OPERATIONS_TMP S
         WHERE S.OPR_DOCUMENT = :V_DOC
           AND S.OPR_ITEM     = :V_AUTO_ITEM_ID;
    END

    RDB$SET_CONTEXT('USER_SESSION', 'AUTOITEM_GUARD', NULL);
WHEN ANY DO
BEGIN
    RDB$SET_CONTEXT('USER_SESSION', 'AUTOITEM_GUARD', NULL);
    EXCEPTION;
END
END^

SET TERM ; ^